
<?php include 'function.php';?>
<?php include 'function2.php';?>
<?php include 'function3.php';?>
<?php


if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: http://localhost/logo/admix/login.php");
    exit();
}
?>
<?php

$db = new DB_con();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $action = $_POST['action'];

    if ($action === 'approve') {
        $db->approveTopupRequest($id); // Updates balance too
        $msg = "Top-up approved successfully.";
    } elseif ($action === 'reject') {
        $db->rejectTopupRequest($id);
        $msg = "Top-up rejected.";
    }
}

$requests = $db->getAllTopupRequests();
?>


<?php include 'header.php';?>

<div class="main-content">
    <div class="container py-4">
        <h2 class="mb-4">Top-Up Requests</h2>

        <?php if (!empty($msg)) : ?>
            <div class="alert alert-success"><?= $msg ?></div>
        <?php endif; ?>

        <div class="table-responsive bg-white rounded shadow-sm p-3">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Transaction ID</th>
                        <th>Payment Date</th>
                        <th>Amount</th>
                        <th>Description</th>
                        <th>Screenshot</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($requests as $row): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['username']) ?></td>
                            <td><?= htmlspecialchars($row['transaction_id']) ?></td>
                            <td><?= htmlspecialchars($row['payment_date']) ?></td>
                            <td>$<?= number_format($row['amount'], 2) ?></td>
                            <td><?= htmlspecialchars($row['ext1']) ?></td>
                            <td>
                                <?php if ($row['image']): ?>
                                    <a href="../<?= $row['image'] ?>" target="_blank">View</a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-<?= 
                                    $row['approved'] === 'approved' ? 'success' : 
                                    ($row['approved'] === 'rejected' ? 'danger' : 'warning') ?>">
                                    <?= ucfirst($row['approved']) ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($row['approved'] == 'pending' || $row['approved'] == 0): ?>
                                    <form method="POST" class="d-flex gap-1">
                                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                        <button name="action" value="approve" class="btn btn-sm btn-success">Approve</button>
                                        <button name="action" value="reject" class="btn btn-sm btn-danger">Reject</button>
                                    </form>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include 'footer.php';?>
