<?php include 'function.php';?>
<?php include 'function2.php';?>

<?php


if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$db = new DB_con();
$error = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $user = $db->loginUser($username, $password); // custom login function

    if ($user) {
        $_SESSION['userid']   = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['email'] = $user['email'];

        if ($user['ext2'] === '1') {
            // User is admin
            $_SESSION['admin_logged_in'] = true;
            header("Location: admix/index.php");
        } else {
            // Normal user
            $_SESSION['user_logged_in'] = true;
            header("Location: users/index.php");
        }
        exit();
    } else {
        $error = "Invalid username or password.";
    }
}
?>
<?php include 'header.php';?>


<main>
      <!-- Breadcrumb -->
      <section class="w-breadcrumb-area" style="
          background: url('assets/img/common/breadcrumb-bg.png') no-repeat
            center center/cover;
        "></section>
      <!-- Breadcrumb End -->

      <!-- Login Form -->


<section class="py-110 bg-offWhite">
  <div class="container">
    <div class="bg-white rounded-3 p-3">
      <div class="row g-4">
        <div class="col-lg-6 p-3 p-lg-5">
          <div class="mb-40">
            <h2 class="section-title mb-2">
              <?= isset($_SESSION['username']) ? 'Welcome, ' . htmlspecialchars($_SESSION['username']) : 'Log in' ?>
            </h2>
            <p class="section-desc">Welcome to 3 dollar vector</p>
          </div>

          <?php if (isset($_SESSION['username'])): ?>
            <div style="text-align: center; margin-top: 20px;">

              <a href="users/" class="w-btn-secondary-lg mb-2">Go to Dashboard</a>

              <form action="users/logout.php" method="POST" style="display:inline;">
                <button type="submit" class="w-btn-secondary-lg-red text-white">Logout</button>
              </form>

            </div>
          <?php else: ?>
            <form method="POST" action="login.php">
              <div class="form-container d-flex flex-column gap-4">
                <?php if (!empty($error)): ?>
                  <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>

                <div class="form-input">
                  <label for="username" class="form-label">Username <span class="text-lime-300">*</span></label>
                  <input type="text" id="username" name="username" placeholder="Enter username" class="form-control shadow-none" required>
                </div>

                <div class="form-input">
                  <label for="password" class="form-label">Password <span class="text-lime-300">*</span></label>
                  <input type="password" id="password" name="password" placeholder="********" class="form-control shadow-none" required>
                </div>

                <div class="d-grid">
                  <button type="submit" class="w-btn-secondary-lg">Log In</button>
                </div>
              </div>
            </form>
          <?php endif; ?>

          <div class="py-5">
            <div class="form-divider d-flex justify-content-center align-items-center">
              <span class="form-divider-text">OR</span>
            </div>
          </div>

          <div class="mt-4">
            <p class="text-center form-text">
              Don’t have an account?
              <a href="register.php"> Create Account </a>
              <br>
              <a href="index.php" class="text-danger fw-bold mt-2 d-inline-block">Go to Home Page</a>
            </p>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="login-img">
            <img src="assets/img/others/1.png" class="img-fluid w-100" alt="">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
      <!-- Login Form End -->
    </main>

<?php include 'footer.php';?>