<?php include '../function.php';?>
<?php include '../function2.php';?>

<?php
$db = new DB_con();

$username = $_SESSION['username'] ?? '';

if (!$username) {
    echo "<div class='alert alert-danger'>Please login first.</div>";
    exit;
}

$user = $db->fetchUserProfile($username);
?>


<?php include 'header.php';?>


<?php 
if (isset($_POST['update'])) {
    $email = $_POST['email'];
    $country = $_POST['country'];
    $state = $_POST['state'];
    $city = $_POST['city'];
    $whatsappno = $_POST['whatsappno'];
    $profilepic = $user['profilepic']; // default

    if (!empty($_FILES['profilepic']['name'])) {
        $uploadDir = '../uploads/profiles/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
        $filename = time() . '_' . basename($_FILES['profilepic']['name']);
        $uploadPath = $uploadDir . $filename;
        if (move_uploaded_file($_FILES['profilepic']['tmp_name'], $uploadPath)) {
            $profilepic = 'uploads/profiles/' . $filename;
        }
    }

    $stmt = $db->dbh->prepare("UPDATE users SET email=?, country=?, state=?, city=?, whatsappno=?, profilepic=? WHERE username=?");
    $stmt->bind_param("sssssss", $email, $country, $state, $city, $whatsappno, $profilepic, $username);
    if ($stmt->execute()) {
        echo "<div class='alert alert-success'>Profile updated.</div>";
        header("Refresh:0"); // refresh to reload updated data
    } else {
        echo "<div class='alert alert-danger'>Update failed.</div>";
    }
}

?>

<div class="main-content">
  <div class="container py-5">
    <h2 class="mb-4">User Profile</h2>

    <div class="bg-white p-4 rounded shadow-sm">
      <div class="row mb-3 fw-bold text-center">
        <div class="col-md-4">Description</div>
        <div class="col-md-4">Profile Pic</div>
      </div>

      <div class="row g-4">
        <div class="col-md-4">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <ul class="list-group list-group-flush">
                <li class="list-group-item"><strong>Username:</strong> <?= htmlspecialchars($user['username']) ?></li>
                <li class="list-group-item"><strong>Email:</strong> <?= htmlspecialchars($user['email']) ?></li>
                <li class="list-group-item"><strong>Country:</strong> <?= htmlspecialchars($user['country']) ?></li>
                <li class="list-group-item"><strong>State:</strong> <?= htmlspecialchars($user['state']) ?></li>
                <li class="list-group-item"><strong>City:</strong> <?= htmlspecialchars($user['city']) ?></li>
                <li class="list-group-item"><strong>WhatsApp:</strong> <?= htmlspecialchars($user['whatsappno']) ?></li>
                <li class="list-group-item"><strong>Status:</strong> <?= htmlspecialchars($user['status']) ?></li>
                <li class="list-group-item"><strong>Account Created:</strong> <?= htmlspecialchars($user['created_at']) ?></li>
                <li class="list-group-item">
                  <strong>Secret Pin:</strong> <span class="text-muted">Hidden - Contact Admin to change</span>
                </li>
              </ul>
            </div>
          </div>
        </div>

        <div class="col-md-4 d-flex align-items-center justify-content-center">
          <div class="border rounded shadow-sm" style="width: 320px; height: 320px; overflow: hidden;">
            <img src="../uploads/profiles/<?= htmlspecialchars($user['profilepic']) ?>"
              alt="Profile Picture"
              style="width: 100%; height: 100%; object-fit: cover;">
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include 'footer.php';?>
