<?php include 'function.php';?>
<?php include 'function2.php';?>
<?php include 'function3.php';?>

<?php include 'header.php';?>



<?php

$username = $_SESSION['username'] ?? '';

if (!$username) {
  echo "<div class='alert alert-danger'>Please login to view this page.</div>";
  exit;
}

$db = new DB_con();

// Fetch balance
$balanceRes = $db->getUserBalance($username);
$balance = $balanceRes['balance'] ?? 0.00;

// Latest Top-ups
$topups = $db->getWalletTransactions($username, 'topup');

// Latest Purchases
$purchases = $db->getWalletTransactions($username, 'purchase');
?>

<div class="main-content">
  <div class="container py-5">
    <h2 class="mb-4">Balance Details</h2>

    <div class="bg-white p-4 rounded shadow-sm">
      <div class="row mb-3 fw-bold text-center">
        <div class="col-md-4">Account Balance</div>
        <div class="col-md-4">Approved Balance</div>
        <div class="col-md-4">Latest Purchase</div>
      </div>

      <div class="row g-4">
        <div class="col-md-4">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <ul class="list-group list-group-flush">
                <li class="list-group-item">
                  <strong>Your Balance</strong>: <br><br>
                  <h1><?= number_format($balance, 2) ?> USD</h1><br>Available
                </li>
                <br>
                <li class="list-group-item">
                  <strong>Latest Update Balance:</strong><br><br>
                  <h3><?= $topups[0]['created_at'] ?? 'No Data' ?></h3>
                </li>
              </ul>
            </div>
          </div>
        </div>

        <div class="col-md-4">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <table class="table">
                <?php foreach ($topups as $t): ?>
                <tr>
                  <td><?= $t['created_at'] ?></td>
                  <td><?= number_format($t['amount'], 2) ?> USD</td>
                </tr>
                <?php endforeach; ?>
              </table>
            </div>
          </div>
        </div>

        <div class="col-md-4">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <table class="table">
                <?php foreach ($purchases as $p): ?>
                <tr>
                  <td><?= htmlspecialchars($p['description']) ?></td>
                  <td><?= number_format($p['amount'], 2) ?> USD</td>
                </tr>
                <?php endforeach; ?>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>

<div class="container py-5">
  
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_SESSION['username'];
    $transaction_id = $_POST['transaction_id'];
    $payment_date = $_POST['payment_date'];
    $amount = $_POST['amount'];
    $ext1 = $_POST['description']; // description stored in ext1

    // Upload file
    $screenshot = '';
    if (!empty($_FILES['screenshot']['name'])) {
        $ext = pathinfo($_FILES['screenshot']['name'], PATHINFO_EXTENSION);
        $screenshot = 'uploads/topups/' . uniqid('topup_') . '.' . $ext;
        move_uploaded_file($_FILES['screenshot']['tmp_name'], '../' . $screenshot);
    }

    $result = $db->submitTopupRequest($username, $transaction_id, $payment_date, $amount, $screenshot, $ext1);

    if ($result['success']) {
        echo '<div class="alert alert-success mt-3">Top-up request submitted successfully.</div>';
    } else {
        echo '<div class="alert alert-danger mt-3">' . htmlspecialchars($result['error']) . '</div>';
    }
}
?>
<form method="POST" enctype="multipart/form-data" class="mt-4">
    <label>Transaction ID</label>
    <input type="text" name="transaction_id" class="form-control mb-2" required>

    <label>Payment Date</label>
    <input type="date" name="payment_date" class="form-control mb-2" required>

    <label>Amount (USD)</label>
    <input type="number" step="0.01" name="amount" class="form-control mb-2" required>

    <label>Short Description (optional)</label>
    <textarea name="description" class="form-control mb-2" placeholder="e.g. Sent via PayPal, ref#12345"></textarea>

    <label>Upload Screenshot</label>
    <input type="file" name="screenshot" accept=".jpg,.jpeg,.png" class="form-control mb-3" required>

    <button class="btn btn-success" type="submit">Submit Top-up</button>
</form>

<br><br>

<?php

$username = $_SESSION['username'];
$requests = $db->getTopupRequestsByUser($username);
?>

<h4 class="mt-5">Your Top-Up Requests</h4>
<table class="table table-bordered">
  <thead>
    <tr>
      <th>Date</th>
      <th>Transaction ID</th>
      <th>Amount</th>
      <th>Description</th>
      <th>Status</th>
      <th>Screenshot</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($requests as $row): ?>
      <tr>
        <td><?= htmlspecialchars($row['payment_date']) ?></td>
        <td><?= htmlspecialchars($row['transaction_id']) ?></td>
        <td><?= htmlspecialchars($row['amount']) ?> USD</td>
        <td><?= htmlspecialchars($row['ext1']) ?></td>
        <td>
          <span class="badge bg-<?= $row['approved'] === 'approved' ? 'success' : ($row['approved'] === 'rejected' ? 'danger' : 'warning') ?>">
            <?= ucfirst($row['approved']) ?>
          </span>
        </td>
        <td>
          <?php if (!empty($row['image'])): ?>
            <a href="../<?= htmlspecialchars($row['image']) ?>" target="_blank">View</a>
          <?php else: ?>
            No file
          <?php endif; ?>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>

</div>


<?php include 'footer.php';?>
