    <?php
session_start();

define('DB_SERVER', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'logo');

class DB_con
{
    public $dbh; // Declare to avoid deprecated dynamic property warning

    function __construct()
    {
        $this->dbh = mysqli_connect(DB_SERVER, DB_USER, DB_PASS, DB_NAME);

        if (mysqli_connect_errno()) {
            echo "Failed to connect to MySQL: " . mysqli_connect_error();
        }
    }

    // Data Insertion Function
    public function insert($fname, $lname, $emailid, $contactno, $address)
    {
        $stmt = $this->dbh->prepare("INSERT INTO tblusers (FirstName, LastName, EmailId, ContactNumber, Address) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $fname, $lname, $emailid, $contactno, $address);
        $stmt->execute();
        return $stmt->affected_rows > 0;
    }

    // Fetch one record by URL
    public function fetchdata($urlx)
    {
        $stmt = $this->dbh->prepare("SELECT * FROM testing WHERE ext2 = ? LIMIT 1");
        $stmt->bind_param("s", $urlx);
        $stmt->execute();
        return $stmt->get_result();
    }

    // Fetch paginated records
    public function fetchdataall($limit, $offset)
    {
        $stmt = $this->dbh->prepare("SELECT * FROM testing LIMIT ? OFFSET ?");
        $stmt->bind_param("ii", $limit, $offset);
        $stmt->execute();
        return $stmt->get_result();
    }

    public function fetchdataalluser($limit, $offset)
{
    // Get the username from session
    $username = $_SESSION['username'];

    // Prepare the SQL query with WHERE, ORDER BY score DESC, LIMIT, and OFFSET
    $stmt = $this->dbh->prepare("SELECT * FROM testing WHERE ext1 = ? ORDER BY score DESC LIMIT ? OFFSET ?");
    $stmt->bind_param("sii", $username, $limit, $offset);
    $stmt->execute();
    return $stmt->get_result();
}


    // Fetch total records
    public function fetchTotalRecords()
    {
        $stmt = $this->dbh->prepare("SELECT COUNT(*) as total FROM testing");
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        return $result['total'];
    }

    public function fetchTotalRecordsuser()
{
    // Get the username from session
    $username = $_SESSION['username'];

    // Prepare and execute the SQL query
    $stmt = $this->dbh->prepare("SELECT COUNT(*) as total FROM testing WHERE ext1 = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();

    $result = $stmt->get_result()->fetch_assoc();
    return $result['total'];
}

    // Fetch single user record
    public function fetchonerecord($userid)
    {
        $stmt = $this->dbh->prepare("SELECT * FROM tblusers WHERE id = ?");
        $stmt->bind_param("i", $userid);
        $stmt->execute();
        return $stmt->get_result();
    }

    // Update user data
    public function update($fname, $lname, $emailid, $contactno, $address, $userid)
    {
        $stmt = $this->dbh->prepare("UPDATE tblusers SET FirstName = ?, LastName = ?, EmailId = ?, ContactNumber = ?, Address = ? WHERE id = ?");
        $stmt->bind_param("sssssi", $fname, $lname, $emailid, $contactno, $address, $userid);
        $stmt->execute();
        return $stmt->affected_rows > 0;
    }

    // Update testing table data (unsafe version: kept for legacy; recommend using the safe one below)
    public function updateData($urlx, $score, $avg, $times)
    {
        $stmt = $this->dbh->prepare("UPDATE testing SET score = ?, times = ?, avg = ? WHERE ext2 = ?");
        $stmt->bind_param("iids", $score, $times, $avg, $urlx);
        $stmt->execute();
        return $stmt->affected_rows > 0;
    }

    // Safe updatereset method using prepared statements
    public function updatereset($urlx, $score, $avg, $times)
    {
        $stmt = $this->dbh->prepare("UPDATE testing SET score = ?, times = ?, avg = ? WHERE id = ?");
        $stmt->bind_param("iids", $score, $times, $avg, $urlx);
        $stmt->execute();
        return $stmt->affected_rows > 0;
    }

    // Delete a user
    public function delete($rid)
    {
        $stmt = $this->dbh->prepare("DELETE FROM tblusers WHERE id = ?");
        $stmt->bind_param("i", $rid);
        $stmt->execute();
        return $stmt->affected_rows > 0;
    }

    public function registerUser($username, $email, $password, $country, $state, $city, $whatsappno, $ext1, $ext2, $ext3, $ipaddress, $macaddress, $profilepic, $seceretpin) {
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    $status = 'active';
    $created_at = date('Y-m-d H:i:s');

    $stmt = $this->dbh->prepare("INSERT INTO users (username, email, password, country, state, city, whatsappno, ext1, ext2, ext3, ipaddress, macaddress, profilepic, seceretpin, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("ssssssssssssssss",
        $username,
        $email,
        $hashedPassword,
        $country,
        $state,
        $city,
        $whatsappno,
        $ext1,
        $ext2,
        $ext3,
        $ipaddress,
        $macaddress,
        $profilepic,
        $seceretpin,
        $status,
        $created_at
    );

    return $stmt->execute();
}

    // Login User
    public function loginUser($username, $password) {
    $stmt = $this->dbh->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 1) {
        $row = $res->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            return $row;
        }
    }
    return false;
}


public function getTotalGamesByUser()
{
    $username = $_SESSION['username'];
    $stmt = $this->dbh->prepare("SELECT COUNT(*) as total FROM testing WHERE ext1 = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['total'];
}

public function countGameTypesByUser()
{
    $username = $_SESSION['username'];

    $stmt = $this->dbh->prepare("SELECT COUNT(DISTINCT game) AS game_types FROM testing WHERE ext1 = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();

    $result = $stmt->get_result()->fetch_assoc();
    return $result['game_types'];
}

public function getUserStats()
{
    $username = $_SESSION['username'];

    // Fetch all needed data in one query
    $stmt = $this->dbh->prepare("
        SELECT 
            COUNT(DISTINCT game) AS game_types,
            SUM(score) AS total_score,
            SUM(avg) AS total_avg,
            SUM(times) AS total_times,
            SUM(CASE WHEN color = 'black' THEN 1 ELSE 0 END) AS black_count,
            SUM(CASE WHEN color = 'white' THEN 1 ELSE 0 END) AS white_count
        FROM testing
        WHERE ext1 = ?
    ");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

public function getUserGameTypes()
{
    $username = $_SESSION['username'];

    $stmt = $this->dbh->prepare("
        SELECT DISTINCT game 
        FROM testing 
        WHERE ext1 = ?
    ");
    $stmt->bind_param("s", $username);
    $stmt->execute();

    $result = $stmt->get_result();
    $games = [];
    while ($row = $result->fetch_assoc()) {
        $games[] = $row['game'];
    }
    return $games;
}


public function insertLogoRequest($name, $file, $email, $contact, $cat, $date, $month, $weekno, $username, $price, $paytype, $logocode, $ipaddress, $designer, $ext1, $ext2, $ext3, $created_at, $updated_at)
{
    $stmt = $this->dbh->prepare("
        INSERT INTO logo_requests 
        (name, file, email, contact, cat, date, month, weekno, username, price, paytype, logocode, ipaddress, designer, ext1, ext2, ext3, created_at, updated_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        die("Prepare failed: " . $this->dbh->error);
    }

    $stmt->bind_param(
        "sssssssssssssssssss", 
        $name, $file, $email, $contact, $cat,
        $date, $month, $weekno, $username,
        $price, $paytype, $logocode, $ipaddress,
        $designer, $ext1, $ext2, $ext3,
        $created_at, $updated_at
    );

    return $stmt->execute();
}
public function fetchAllLogosByUser($username)
{
    $stmt = $this->dbh->prepare("SELECT * FROM logo_requests WHERE username = ? ORDER BY id DESC");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    return $stmt->get_result();
}
public function fetchLogoById($logocode)
{
    $stmt = $this->dbh->prepare("SELECT * FROM logo_requests WHERE logocode = ?");
    $stmt->bind_param("s", $logocode);
    $stmt->execute();
    return $stmt->get_result();
}

public function fetchUserProfile($username)
{
    $stmt = $this->dbh->prepare("SELECT username, email, country, state, city, whatsappno, profilepic, status, created_at FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

public function getUserBalance($username)
    {
        $stmt = $this->dbh->prepare("SELECT balance FROM user_balances WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        return $row['balance'] ?? 0.00;
    }

    // Get topups or purchases
    public function getWalletTransactions($username, $type)
    {
        $stmt = $this->dbh->prepare("SELECT * FROM wallet_transactions WHERE username = ? AND type = ? ORDER BY created_at DESC LIMIT 15");
        $stmt->bind_param("ss", $username, $type);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }

    // Add topup
    public function addTopup($username, $amount)
    {
        $stmt = $this->dbh->prepare("INSERT INTO wallet_transactions (username, amount, type, created_at) VALUES (?, ?, 'topup', NOW())");
        $stmt->bind_param("sd", $username, $amount);
        $stmt->execute();
        $this->updateBalance($username, $amount);
    }

    // Deduct on purchase
    public function deductPurchase($username, $amount, $logoname)
    {
        $stmt = $this->dbh->prepare("INSERT INTO wallet_transactions (username, amount, type, description, created_at) VALUES (?, ?, 'purchase', ?, NOW())");
        $stmt->bind_param("sds", $username, $amount, $logoname);
        $stmt->execute();
        $this->updateBalance($username, -$amount);
    }

    // Update balance helper
    private function updateBalance($username, $change)
    {
        $stmt = $this->dbh->prepare("INSERT INTO user_balances (username, balance) VALUES (?, ?) ON DUPLICATE KEY UPDATE balance = balance + VALUES(balance)");
        $stmt->bind_param("sd", $username, $change);
        $stmt->execute();
    }

public function submitTopupRequest($username, $transaction_id, $payment_date, $amount, $screenshot, $ext1 = null)
{
    try {
        $stmt = $this->dbh->prepare("INSERT INTO topup_requests 
            (username, transaction_id, payment_date, amount, image, ext1, approved, created_at, updated_at) 
            VALUES (?, ?, ?, ?, ?, ?, 'pending', NOW(), NOW())");

$stmt->bind_param("ssssss", $username, $transaction_id, $payment_date, $amount, $screenshot, $ext1);
        $stmt->execute();
        return ['success' => true];
    } catch (mysqli_sql_exception $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}
// Fetch all topup requests (admin view)
public function getAllTopupRequests()
{
    $result = $this->dbh->query("SELECT * FROM topup_requests ORDER BY id DESC");
    return $result->fetch_all(MYSQLI_ASSOC);
}

// Approve topup request
public function approveTopup($id)
{
    // Get the request details
    $stmt = $this->dbh->prepare("SELECT username, amount FROM topup_requests WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();

    if ($res) {
        $username = $res['username'];
        $amount = $res['amount'];

        // Update balance
        $this->updateBalance($username, $amount);

        // Mark as approved
        $update = $this->dbh->prepare("UPDATE topup_requests SET approved = 'approved', updated_at = NOW() WHERE id = ?");
        $update->bind_param("i", $id);
        return $update->execute();
    }

    return false;
}

public function getTopupRequestsByUser($username)
{
    $stmt = $this->dbh->prepare("SELECT * FROM topup_requests WHERE username = ? ORDER BY created_at DESC");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

public function fetchAllUsers()
{
    $stmt = $this->dbh->prepare("SELECT id, username, email, country, state, city, whatsappno, status, created_at FROM users ORDER BY id DESC");
    $stmt->execute();
    return $stmt->get_result();
}
public function updateUserById($id, $username, $email, $country, $state, $city, $whatsappno, $status)
{
    $stmt = $this->dbh->prepare("UPDATE users SET username = ?, email = ?, country = ?, state = ?, city = ?, whatsappno = ?, status = ? WHERE id = ?");
    $stmt->bind_param("sssssssi", $username, $email, $country, $state, $city, $whatsappno, $status, $id);
    return $stmt->execute();
}


public function approveTopupRequest($id)
{
    $stmt = $this->dbh->prepare("SELECT username, amount FROM topup_requests WHERE id = ? AND approved = 'pending'");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $this->updateBalance($row['username'], $row['amount']);
        $update = $this->dbh->prepare("UPDATE topup_requests SET approved = 'approved', updated_at = NOW() WHERE id = ?");
        $update->bind_param("i", $id);
        $update->execute();
    }
}

// Reject Top-up Request
public function rejectTopupRequest($id)
{
    $stmt = $this->dbh->prepare("UPDATE topup_requests SET approved = 'rejected', updated_at = NOW() WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
}

public function fetchAllTickets()
{
    $stmt = $this->dbh->prepare("SELECT * FROM tickets ORDER BY created_at DESC");
    $stmt->execute();
    return $stmt->get_result();
}


public function fetchTicketById($id)
{
    $stmt = $this->dbh->prepare("SELECT * FROM tickets WHERE id = ?");
    $stmt->bind_param("i", $id); // "i" means integer
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}

public function insertTicketReply($ticket_id, $username, $message, $replied_by) {
    $stmt = $this->dbh->prepare("INSERT INTO ticket_replies (ticket_id, username, message, replied_by, created_at) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("isss", $ticket_id, $username, $message, $replied_by);
    return $stmt->execute();
}

public function fetchTicketReplies($ticket_id) {
    $stmt = $this->dbh->prepare("SELECT * FROM ticket_replies WHERE ticket_id = ? ORDER BY created_at ASC");
    $stmt->bind_param("i", $ticket_id);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_all(MYSQLI_ASSOC);
}

public function updateTicketStatus($ticket_id, $status) {
    $stmt = $this->dbh->prepare("UPDATE tickets SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $status, $ticket_id);
    return $stmt->execute();
}

public function fetchAllLogos() {
    $stmt = $this->dbh->prepare("SELECT * FROM logo_requests ORDER BY id DESC");
    $stmt->execute();
    return $stmt->get_result();
}
public function getTotalBalance($username) {
    $stmt = $this->dbh->prepare("SELECT SUM(amount) AS total FROM topup_requests WHERE username = ? AND approved = 'approved'");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['total'] ?? 0;
}

// Current Balance (from user_balances)
public function getCurrentBalance($username) {
    $stmt = $this->dbh->prepare("SELECT balance FROM user_balances WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['balance'] ?? 0;
}

// Approved Logos (logo_requests paytype = 'approved')
public function getApprovedLogos($username) {
    $stmt = $this->dbh->prepare("SELECT COUNT(*) AS count FROM logo_requests WHERE username = ? AND paytype = 'approved'");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['count'] ?? 0;
}

// Pending Logos (logo_requests ext1 = 'pending')
public function getPendingLogos($username) {
    $stmt = $this->dbh->prepare("SELECT COUNT(*) AS count FROM logo_requests WHERE username = ? AND ext1 = 'pending'");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['count'] ?? 0;
}

// Cancelled Logos (logo_requests ext1 = 'cancel')
public function getCancelledLogos($username) {
    $stmt = $this->dbh->prepare("SELECT COUNT(*) AS count FROM logo_requests WHERE username = ? AND ext1 = 'cancel'");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['count'] ?? 0;
}

// Tickets (count from tickets)
public function getTicketCount($username) {
    $stmt = $this->dbh->prepare("SELECT COUNT(*) AS count FROM tickets WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    return $result['count'] ?? 0;
}


}


?>
