<?php include 'function.php';?>
<?php include 'function2.php';?>
<?php include 'function3.php';?>

<?php
$db = new DB_con();

// No user filtering — fetch all logos
$logos = $db->fetchAllLogos(); // Create this method to return all logos
?>

<?php include 'header.php';?>

<div class="main-content">
    <div>
        <h3 class="text-24 fw-bold text-dark-300 mb-2">All Logo Orders</h3>
        <div class="overflow-x-auto">
            <div class="w-100">
                <table class="w-100 dashboard-table">
                    <thead class="pb-3">
                        <tr>
                            <th class="ps-4">Order ID</th>
                            <th class="ps-4">Order Name</th>
                            <th>Price</th>
                            <th>Date</th>
                            <th>Paytype</th>
                            <th>Category</th>
                            <th class="text-start">Status</th>
                            <th>Files</th>
                            <th>View</th>
                            <th>Cancel</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $logos->fetch_assoc()): ?>
                        <tr class="<?= $row['ext1'] === 'cancel' ? 'status-row-cancel' : '' ?>">
                            <td class="text-dark-200"><?= $row['logocode'] ?></td>
                            <td>
                                <div class="d-flex gap-3 align-items-center project-name">
                                    <div class="order-img">
                                        <img src="../uploads/<?= $row['file'] ?>" alt="">
                                    </div>
                                    <div>
                                        <a href="#" class="project-link"><?= htmlspecialchars($row['name']) ?></a>
                                    </div>
                                </div>
                            </td>
                            <td class="text-dark-200">$<?= $row['price'] ?></td>
                            <td class="text-dark-200"><?= $row['date'] ?></td>
                            <td class="text-dark-200"><?= $row['paytype'] ?></td>
                            <td class="text-dark-200"><?= $row['cat'] ?></td>
                            <td class="text-start">
                                <span class="status-badge <?= $row['ext1'] === 'cancel' ? 'status-row-cancel2' : '' ?>">
                                    <?= ucfirst($row['ext1']) ?>
                                </span>
                            </td>
                            <td class="text-dark-200"><?= $row['ext2'] === 'nofiles' ? 'No files' : 'Files available' ?></td>
                            <td class="text-dark-200">
                                <a href="details.php?id=<?= $row['logocode'] ?>">View Details</a>
                            </td>
                            <td class="text-dark-200">
                                <?php if ($row['ext1'] !== 'cancel'): ?>
                                <a href="cancel-request.php?id=<?= $row['id'] ?>" onclick="return confirm('Are you sure you want to cancel this request?')">Cancel Request</a>
                                <?php else: ?>
                                Cancelled
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php';?>