
<?php include 'function.php';?>
<?php include 'function2.php';?>
<?php include 'function3.php';?>
<?php


if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: http://localhost/logo/admix/login.php");
    exit();
}
?>
<?php

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "Invalid request.";
    exit;
}

$userId = intval($_GET['id']);
$db = new DB_con();

// Fetch user by ID
$stmt = $db->dbh->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    echo "User not found.";
    exit;
}
?>

<?php include 'header.php';?>

<div class="main-content">
    


            <!-- Content -->
            <div class="container py-5">
  <div class="bg-white p-4 rounded shadow-sm">
    <div class="row mb-3 fw-bold text-center">
      <div class="col-md-4">User Info</div>
      <div class="col-md-4">Profile Picture</div>
      <div class="col-md-4">Extras</div>
    </div>

    <div class="row g-4">
      <!-- User Info -->
      <div class="col-md-4">
        <div class="card shadow-sm border-0 h-100">
          <div class="card-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><strong>Username:</strong> <?= htmlspecialchars($user['username']) ?></li>
              <li class="list-group-item"><strong>Email:</strong> <?= htmlspecialchars($user['email']) ?></li>
              <li class="list-group-item"><strong>Country:</strong> <?= htmlspecialchars($user['country']) ?></li>
              <li class="list-group-item"><strong>State:</strong> <?= htmlspecialchars($user['state']) ?></li>
              <li class="list-group-item"><strong>City:</strong> <?= htmlspecialchars($user['city']) ?></li>
              <li class="list-group-item"><strong>WhatsApp:</strong> <?= htmlspecialchars($user['whatsappno']) ?></li>
              <li class="list-group-item"><strong>Status:</strong> 
                <span class="badge bg-<?= $user['status'] == 'active' ? 'success' : 'secondary' ?>">
                  <?= htmlspecialchars($user['status']) ?>
                </span>
              </li>
              <li class="list-group-item"><strong>Joined:</strong> <?= htmlspecialchars($user['created_at']) ?></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- Profile Pic -->
      <div class="col-md-4 d-flex align-items-center justify-content-center">
        <div class="border rounded shadow-sm" style="width: 320px; height: 320px; overflow: hidden;">
          <img src="../uploads/profile/<?= htmlspecialchars($user['profilepic']) ?>" alt="Profile Picture" style="width: 100%; height: 100%; object-fit: cover;">
        </div>
      </div>

      <!-- Extras -->
      <div class="col-md-4">
        <div class="card shadow-sm border-0 h-100">
          <div class="card-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><strong>IP Address:</strong> <?= htmlspecialchars($user['ipaddress']) ?></li>
              <li class="list-group-item"><strong>MAC Address:</strong> <?= htmlspecialchars($user['macaddress']) ?></li>
              <li class="list-group-item"><strong>Security Pin:</strong> <?= htmlspecialchars($user['seceretpin']) ?></li>
              <li class="list-group-item"><strong>Ext1:</strong> <?= htmlspecialchars($user['ext1']) ?></li>
              <li class="list-group-item"><strong>Ext2:</strong> <?= htmlspecialchars($user['ext2']) ?></li>
              <li class="list-group-item"><strong>Ext3:</strong> <?= htmlspecialchars($user['ext3']) ?></li>
            </ul>
          </div>
        </div>
      </div>
    </div>

  
    <div class="mt-4 text-center">
  <a href="admin-dashboard.php" class="btn btn-secondary me-2">← Back to User List</a>
  <a href="edituser.php?id=<?= $user['id'] ?>" class="btn btn-primary">✎ Edit User</a>
</div>

  </div>
</div>
  
          
</div>
<?php include 'footer.php';?>
