<?php include '../function.php';?>
<?php include '../function2.php';?>
<?php include 'header.php';?>

<?php

$username = $_SESSION['username'] ?? '';

if (!$username) {
  echo "<div class='alert alert-danger'>Please login to view this page.</div>";
  exit;
}

$db = new DB_con();

// Fetch balance

$balance = $db->getUserBalance($username);

// Latest Top-ups
$topups = $db->getTopupRequests($username);


// Latest Purchases
$purchases = $db->getWalletTransactions($username, 'purchase');
?>

<div class="main-content">
 
    
    <div class="bg-white p-4 rounded shadow-sm">
      

      <div class="row g-4"><div>
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <ul class="list-group list-group-flush">
                <li class="list-group-item">
                  <strong>Your Balance</strong>: 
                  <h1>$<?= number_format($balance, 2) ?></h1> Available
                </li>
                
               
              </ul>
            </div>
          </div>
        </div></div>
    </div>

    <div class="bg-white p-4 rounded shadow-sm">
      <div class="row mb-3 fw-bold text-center">
       
        <div class="col-md-6">Approved Balance</div>
        <div class="col-md-6">Latest Purchase</div>
      </div>

      <div class="row g-4">
        

        <div class="col-md-6">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <table class="table">

            <?php foreach ($topups as $t): ?>
  <tr>
    <td><?= htmlspecialchars($t['transaction_id']) ?></td>
    <td><?= date('Y-m-d', strtotime($t['payment_date'])) ?></td>
    <td><?= number_format($t['amount'], 2) ?> USD</td>
    
  </tr>
<?php endforeach; ?>
              </table>
            </div>
          </div>
        </div>

        <div class="col-md-6">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
              <table class="table">
                <?php foreach ($purchases as $p): ?>
                <tr>
                  <td> <a href="details.php?id=<?= urlencode($p['description']) ?>">
    <?= htmlspecialchars($p['description']) ?>
  </a></td>
                 
                    <td><?= date('Y-m-d', strtotime($p['created_at'])) ?></td>
                     <td><?= number_format($p['amount'], 2) ?> USD</td>
                </tr>
                <?php endforeach; ?>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>



<div class="container py-5">
  

<?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success mt-3">Top-up request submitted successfully.</div>
<?php elseif (isset($_GET['error'])): ?>
    <div class="alert alert-danger mt-3"><?= htmlspecialchars($_GET['error']) ?></div>
<?php endif; ?>
<form action="balanceupdate.php" method="POST" enctype="multipart/form-data" class="mt-4">
    <label>Transaction ID</label>
    <input type="text" name="transaction_id" class="form-control mb-2" required>

    <label>Payment Date</label>
    <input type="date" name="payment_date" class="form-control mb-2" required>

    <label>Amount (USD)</label>
    <input type="number" step="0.01" name="amount" class="form-control mb-2" required>

    <label>Short Description (optional)</label>
    <textarea name="description" class="form-control mb-2" placeholder="e.g. Sent via PayPal, ref#12345"></textarea>

    <label>Upload Screenshot</label>
    <input type="file" name="screenshot" accept=".jpg,.jpeg,.png" class="form-control mb-3" required>

    <button class="btn btn-success" type="submit">Submit Top-up</button>
</form>

<br><br>

<?php

$username = $_SESSION['username'];
$requests = $db->getTopupRequestsByUser($username);
?>

<h4 class="mt-5">Your Top-Up Requests</h4>
<table class="table table-bordered">
  <thead>
    <tr>
      <th>Date</th>
      <th>Transaction ID</th>
      <th>Amount</th>
      <th>Description</th>
      <th>Status</th>
      <th>Screenshot</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($requests as $row): ?>
      <tr>
        <td><?= htmlspecialchars($row['payment_date']) ?></td>
        <td><?= htmlspecialchars($row['transaction_id']) ?></td>
        <td><?= htmlspecialchars($row['amount']) ?> USD</td>
        <td><?= htmlspecialchars($row['ext1']) ?></td>
        <td>
          <span class="badge bg-<?= $row['approved'] === 'approved' ? 'success' : ($row['approved'] === 'rejected' ? 'danger' : 'warning') ?>">
            <?= ucfirst($row['approved']) ?>
          </span>
        </td>
        <td>
          <?php if (!empty($row['image'])): ?>
            <a href="../<?= htmlspecialchars($row['image']) ?>" target="_blank">View</a>
          <?php else: ?>
            No file
          <?php endif; ?>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>

</div>


<?php include 'footer.php';?>
